#include <bits/stdc++.h>
using namespace std;

struct Cvor {
    long long zbir;   // S[v] = v * cnt[v]  (kljuc po kome sortiramo)
    int vrednost;     // sam broj v (za razbijanje veza)
    int prioritet;
    Cvor *levo, *desno;
    int velicina;     // broj cvorova u podstablu
    long long podsuma; // zbir "zbir" u podstablu

    Cvor(long long _zbir, int _vrednost, int _prioritet)
        : zbir(_zbir),
          vrednost(_vrednost),
          prioritet(_prioritet),
          levo(nullptr),
          desno(nullptr),
          velicina(1),
          podsuma(_zbir) {}
};

mt19937 rng((uint32_t)chrono::steady_clock::now().time_since_epoch().count());

int velicina(Cvor *t) {
    return t ? t->velicina : 0;
}

long long podsuma(Cvor *t) {
    return t ? t->podsuma : 0;
}

void azuriraj(Cvor *t) {
    if (!t) return;
    t->velicina = 1 + velicina(t->levo) + velicina(t->desno);
    t->podsuma = t->zbir + podsuma(t->levo) + podsuma(t->desno);
}

// poredimo par (z1, v1) < (z2, v2)
bool manji(long long z1, int v1, long long z2, int v2) {
    if (z1 != z2) return z1 < z2;
    return v1 < v2;
}

// spoji dva treapa L i R, svi u L < svi u R
Cvor* spoji(Cvor *L, Cvor *R) {
    if (!L) return R;
    if (!R) return L;
    if (L->prioritet > R->prioritet) {
        L->desno = spoji(L->desno, R);
        azuriraj(L);
        return L;
    } else {
        R->levo = spoji(L, R->levo);
        azuriraj(R);
        return R;
    }
}

// podeli po kljucu (zbir, vrednost): levo < key, desno >= key
void podeliPoKljucu(Cvor *t, long long zbir, int vrednost, Cvor* &L, Cvor* &R) {
    if (!t) {
        L = R = nullptr;
        return;
    }
    if (manji(t->zbir, t->vrednost, zbir, vrednost)) {
        // t ide u levo podstablo
        podeliPoKljucu(t->desno, zbir, vrednost, t->desno, R);
        L = t;
        azuriraj(L);
    } else {
        // t ide u desno podstablo
        podeliPoKljucu(t->levo, zbir, vrednost, L, t->levo);
        R = t;
        azuriraj(R);
    }
}

void ubaci(Cvor* &koren, long long zbir, int vrednost) {
    Cvor *novi = new Cvor(zbir, vrednost, (int)rng());
    if (!koren) {
        koren = novi;
        return;
    }
    Cvor *L, *R;
    podeliPoKljucu(koren, zbir, vrednost, L, R);
    koren = spoji(spoji(L, novi), R);
}

void obrisi(Cvor* &koren, long long zbir, int vrednost) {
    if (!koren) return;
    Cvor *L, *mid, *R;
    // odvojimo < key, >= key
    podeliPoKljucu(koren, zbir, vrednost, L, R);
    // u R odvojimo baš taj kljuc i > key
    podeliPoKljucu(R, zbir, vrednost + 1, mid, R); // trik: (zbir, vrednost+1) > (zbir, vrednost), a <= (sledeci veci ili veci zbir)
    // mid bi trebalo da sadrži ili nullptr ili baš jedan cvor sa kljucem (zbir, vrednost)
    // obrišemo mid
    // (ne mora ni delete obavezno, ali možemo)
    // spojimo nazad
    koren = spoji(L, R);
    // napomena: ovo briše SVE cvorove sa tim kljucem; u našem modelu ima tacno jedan po vrednosti v, pa je ok.
}

// split po velicini: prvih k cvorova u L, ostali u R
void podeliPoVelicini(Cvor *t, int k, Cvor* &L, Cvor* &R) {
    if (!t) {
        L = R = nullptr;
        return;
    }
    int vel_levo = velicina(t->levo);
    if (k <= vel_levo) {
        // sve što treba ide u levo podstablo
        podeliPoVelicini(t->levo, k, L, t->levo);
        R = t;
        azuriraj(R);
    } else {
        // uzimamo ceo levo + ovaj cvor i još (k - vel_levo - 1) iz desnog
        podeliPoVelicini(t->desno, k - vel_levo - 1, t->desno, R);
        L = t;
        azuriraj(L);
    }
}

// suma T najmanjih "zbir" vrednosti
long long sumaPrvihT(Cvor* &koren, int T) {
    if (!koren || T <= 0) return 0;
    if (T >= velicina(koren)) return podsuma(koren);

    Cvor *L, *R;
    podeliPoVelicini(koren, T, L, R);
    long long rezultat = podsuma(L);
    koren = spoji(L, R);  // vratimo stablo nazad
    return rezultat;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N, Q;
    cin >> N >> Q;

    vector<int> a(N + 1);
    vector<int> broj_pojava(N + 1, 0);

    for (int i = 1; i <= N; i++) {
        cin >> a[i];
        broj_pojava[a[i]]++;
    }

    Cvor *koren = nullptr;
    int razlicitih = 0;

    // inicijalno ubacimo sve brojeve koji se pojavljuju
    for (int v = 1; v <= N; v++) {
        if (broj_pojava[v] > 0) {
            razlicitih++;
            long long s = 1LL * v * broj_pojava[v];
            ubaci(koren, s, v);
        }
    }

    while (Q--) {
        int t;
        cin >> t;
        if (t == 1) {
            int k;
            cin >> k;
            int poteza = N - k;
            if (poteza >= razlicitih) {
                cout << 0 << '\n';
            } else {
                int T = razlicitih - poteza; // koliko grupa OSTANE
                long long odgovor = sumaPrvihT(koren, T);
                cout << odgovor << '\n';
            }
        } else {
            int x, y;
            cin >> x >> y;
            int stari = a[x];
            if (stari == y) continue;

            // prvo izbacimo doprinos starog broja
            {
                int c = broj_pojava[stari];
                long long stari_zbir = 1LL * stari * c;
                obrisi(koren, stari_zbir, stari);
                broj_pojava[stari]--;
                if (broj_pojava[stari] == 0) {
                    razlicitih--;
                } else {
                    long long novi_zbir = 1LL * stari * broj_pojava[stari];
                    ubaci(koren, novi_zbir, stari);
                }
            }

            // zatim dodamo doprinos novog broja
            {
                int c = broj_pojava[y];
                if (c > 0) {
                    long long stari_zbir = 1LL * y * c;
                    obrisi(koren, stari_zbir, y);
                } else {
                    razlicitih++;
                }
                broj_pojava[y]++;
                long long novi_zbir = 1LL * y * broj_pojava[y];
                ubaci(koren, novi_zbir, y);
            }

            a[x] = y;
        }
    }

    return 0;
}